/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.microsoft.playwright.APIResponse;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.RawHeaders;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.HttpHeader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;

class APIResponseImpl
implements APIResponse {
    final APIRequestContextImpl context;
    private final JsonObject initializer;
    private final RawHeaders headers;

    APIResponseImpl(APIRequestContextImpl apiRequestContext, JsonObject response) {
        this.context = apiRequestContext;
        this.initializer = response;
        this.headers = new RawHeaders(Arrays.asList((HttpHeader[])Serialization.gson().fromJson((JsonElement)this.initializer.getAsJsonArray("headers"), HttpHeader[].class)));
    }

    @Override
    public byte[] body() {
        try {
            JsonObject params = new JsonObject();
            params.addProperty("fetchUid", this.fetchUid());
            JsonObject json = this.context.sendMessage("fetchResponseBody", params, ChannelOwner.NO_TIMEOUT).getAsJsonObject();
            if (!json.has("binary")) {
                throw new PlaywrightException("Response has been disposed");
            }
            return Base64.getDecoder().decode(json.get("binary").getAsString());
        }
        catch (PlaywrightException e) {
            if (Utils.isSafeCloseError(e)) {
                throw new PlaywrightException("Response has been disposed");
            }
            throw e;
        }
    }

    @Override
    public void dispose() {
        JsonObject params = new JsonObject();
        params.addProperty("fetchUid", this.fetchUid());
        this.context.sendMessage("disposeAPIResponse", params, ChannelOwner.NO_TIMEOUT);
    }

    @Override
    public Map<String, String> headers() {
        return this.headers.headers();
    }

    @Override
    public List<HttpHeader> headersArray() {
        return this.headers.headersArray();
    }

    @Override
    public boolean ok() {
        int status = this.status();
        return status == 0 || status >= 200 && status <= 299;
    }

    @Override
    public int status() {
        return this.initializer.get("status").getAsInt();
    }

    @Override
    public String statusText() {
        return this.initializer.get("statusText").getAsString();
    }

    @Override
    public String text() {
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    String fetchUid() {
        return this.initializer.get("fetchUid").getAsString();
    }

    List<String> fetchLog() {
        JsonObject params = new JsonObject();
        params.addProperty("fetchUid", this.fetchUid());
        JsonObject json = this.context.sendMessage("fetchLog", params, ChannelOwner.NO_TIMEOUT).getAsJsonObject();
        JsonArray log = json.get("log").getAsJsonArray();
        return (List)Serialization.gson().fromJson((JsonElement)log, new TypeToken<List<String>>(){}.getType());
    }
}

