/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.impl.ChannelOwner;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class LocalUtils
extends ChannelOwner {
    LocalUtils(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    JsonArray deviceDescriptors() {
        return this.initializer.getAsJsonArray("deviceDescriptors");
    }

    void zip(Path zipFile, JsonArray entries, String stacksId, boolean appendMode, boolean includeSources) {
        JsonObject params = new JsonObject();
        params.addProperty("zipFile", zipFile.toString());
        params.add("entries", (JsonElement)entries);
        params.addProperty("mode", appendMode ? "append" : "write");
        params.addProperty("stacksId", stacksId);
        params.addProperty("includeSources", Boolean.valueOf(includeSources));
        this.sendMessage("zip", params, NO_TIMEOUT);
    }

    void traceDiscarded(String stacksId) {
        JsonObject params = new JsonObject();
        params.addProperty("stacksId", stacksId);
        this.sendMessage("traceDiscarded", params, NO_TIMEOUT);
    }

    String tracingStarted(String tracesDir, String traceName) {
        JsonObject params = new JsonObject();
        if (tracesDir != null) {
            params.addProperty("tracesDir", "");
        }
        params.addProperty("traceName", traceName);
        JsonObject json = this.connection.localUtils().sendMessage("tracingStarted", params, NO_TIMEOUT).getAsJsonObject();
        return json.get("stacksId").getAsString();
    }

    public Pattern globToRegex(String glob, String baseURL, boolean webSocketUrl) {
        JsonObject params = new JsonObject();
        params.addProperty("glob", glob);
        if (baseURL != null) {
            params.addProperty("baseURL", baseURL);
        }
        params.addProperty("webSocketUrl", Boolean.valueOf(webSocketUrl));
        JsonObject json = this.connection.localUtils().sendMessage("globToRegex", params, NO_TIMEOUT).getAsJsonObject();
        String regex = json.get("regex").getAsString();
        return Pattern.compile(regex);
    }
}

