/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

class LoggingSupport {
    private static final boolean isEnabled;
    private static final DateTimeFormatter timestampFormat;

    LoggingSupport() {
    }

    static void logWithTimestamp(String message) {
        String timestamp = ZonedDateTime.now().format(timestampFormat);
        System.err.println(timestamp + " " + message);
    }

    static void logApiIfEnabled(String message) {
        if (isEnabled) {
            LoggingSupport.logApi(message);
        }
    }

    static void logApi(String message) {
        LoggingSupport.logWithTimestamp("pw:api " + message);
    }

    static {
        String debug = System.getenv("DEBUG");
        isEnabled = debug != null && debug.contains("pw:api");
        timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.of("UTC"));
    }
}

