/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Selectors;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.LoggingSupport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class SelectorsImpl
extends LoggingSupport
implements Selectors {
    protected final List<BrowserContextImpl> contextsForSelectors = new ArrayList<BrowserContextImpl>();
    protected final List<JsonObject> selectorEngines = new ArrayList<JsonObject>();
    String testIdAttributeName = "data-testid";

    @Override
    public void setTestIdAttribute(String attributeName) {
        if (attributeName == null) {
            throw new PlaywrightException("Test id attribute cannot be null");
        }
        this.testIdAttributeName = attributeName;
        for (BrowserContextImpl context : this.contextsForSelectors) {
            try {
                JsonObject params = new JsonObject();
                params.addProperty("testIdAttributeName", attributeName);
                context.sendMessageAsync("setTestIdAttributeName", params);
            }
            catch (PlaywrightException playwrightException) {}
        }
    }

    @Override
    public void register(String name, String script, Selectors.RegisterOptions options) {
        this.registerImpl(name, script, options);
    }

    @Override
    public void register(String name, Path path, Selectors.RegisterOptions options) {
        byte[] buffer;
        try {
            buffer = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to read selector from file: " + path, e);
        }
        this.registerImpl(name, new String(buffer, StandardCharsets.UTF_8), options);
    }

    private void registerImpl(String name, String script, Selectors.RegisterOptions options) {
        if (this.selectorEngines.stream().anyMatch(engine -> name.equals(engine.get("name").getAsString()))) {
            throw new PlaywrightException("selectors.register: \"" + name + "\" selector engine has been already registered");
        }
        JsonObject engine2 = new JsonObject();
        engine2.addProperty("name", name);
        engine2.addProperty("source", script);
        if (options != null && options.contentScript != null) {
            engine2.addProperty("contentScript", options.contentScript);
        }
        for (BrowserContextImpl context : this.contextsForSelectors) {
            JsonObject params = new JsonObject();
            params.add("selectorEngine", (JsonElement)engine2);
            context.sendMessage("registerSelectorEngine", params, ChannelOwner.NO_TIMEOUT);
        }
        this.selectorEngines.add(engine2);
    }
}

