/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Channel;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.SerializedArgument;
import com.microsoft.playwright.impl.SerializedError;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.BrowserChannel;
import com.microsoft.playwright.options.ColorScheme;
import com.microsoft.playwright.options.Contrast;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.ForcedColors;
import com.microsoft.playwright.options.HttpCredentialsSend;
import com.microsoft.playwright.options.KeyboardModifier;
import com.microsoft.playwright.options.LoadState;
import com.microsoft.playwright.options.Media;
import com.microsoft.playwright.options.MouseButton;
import com.microsoft.playwright.options.ReducedMotion;
import com.microsoft.playwright.options.SameSiteAttribute;
import com.microsoft.playwright.options.ScreenshotAnimations;
import com.microsoft.playwright.options.ScreenshotCaret;
import com.microsoft.playwright.options.ScreenshotScale;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.ServiceWorkerPolicy;
import com.microsoft.playwright.options.ViewportSize;
import com.microsoft.playwright.options.WaitForSelectorState;
import com.microsoft.playwright.options.WaitUntilState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;

class Serialization {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateSerializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).registerTypeAdapter(SameSiteAttribute.class, (Object)new SameSiteAdapter().nullSafe()).registerTypeAdapter(BrowserChannel.class, new ToLowerCaseAndDashSerializer()).registerTypeAdapter(ColorScheme.class, new ToLowerCaseAndDashSerializer()).registerTypeAdapter(Contrast.class, new ToLowerCaseAndDashSerializer()).registerTypeAdapter(Media.class, new ToLowerCaseSerializer()).registerTypeAdapter(ForcedColors.class, new ToLowerCaseSerializer()).registerTypeAdapter(HttpCredentialsSend.class, new ToLowerCaseSerializer()).registerTypeAdapter(ReducedMotion.class, new ToLowerCaseAndDashSerializer()).registerTypeAdapter(ScreenshotAnimations.class, new ToLowerCaseSerializer()).registerTypeAdapter(ScreenshotType.class, new ToLowerCaseSerializer()).registerTypeAdapter(ScreenshotScale.class, new ToLowerCaseSerializer()).registerTypeAdapter(ScreenshotCaret.class, new ToLowerCaseSerializer()).registerTypeAdapter(ServiceWorkerPolicy.class, new ToLowerCaseAndDashSerializer()).registerTypeAdapter(MouseButton.class, new ToLowerCaseSerializer()).registerTypeAdapter(LoadState.class, new ToLowerCaseSerializer()).registerTypeAdapter(WaitUntilState.class, new ToLowerCaseSerializer()).registerTypeAdapter(WaitForSelectorState.class, new ToLowerCaseSerializer()).registerTypeAdapter(new TypeToken<List<KeyboardModifier>>(){}.getType(), (Object)new KeyboardModifiersSerializer()).registerTypeAdapter(Optional.class, (Object)new OptionalSerializer()).registerTypeHierarchyAdapter(JSHandleImpl.class, (Object)new HandleSerializer()).registerTypeAdapter(new TypeToken<Map<String, String>>(){}.getType(), (Object)new StringMapSerializer()).registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new FirefoxUserPrefsSerializer()).registerTypeHierarchyAdapter(Path.class, (Object)new PathSerializer()).create();
    static final Gson jsonDataSerializer = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new DateSerializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeSerializer()).serializeNulls().create();
    private static final DateFormat dateFormat = Serialization.iso8601Format();

    Serialization() {
    }

    static Gson gson() {
        return gson;
    }

    static SerializedError serializeError(Throwable e) {
        SerializedError result = new SerializedError();
        result.error = new SerializedError.Error();
        result.error.message = e.getMessage();
        result.error.name = e.getClass().getName();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(out));
        result.error.stack = new String(out.toByteArray(), StandardCharsets.UTF_8);
        return result;
    }

    static SerializedArgument serializeArgument(Object arg) {
        return new ValueSerializer(arg).toSerializedArgument();
    }

    static <T> T deserialize(SerializedValue value) {
        return Serialization.deserialize(value, new HashMap<Integer, Object>());
    }

    private static <T> T deserialize(SerializedValue value, Map<Integer, Object> idToValue) {
        if (value.ref != null) {
            return (T)idToValue.get(value.ref);
        }
        if (value.n != null) {
            if (value.n.doubleValue() == (double)value.n.intValue()) {
                return (T)Integer.valueOf(value.n.intValue());
            }
            return (T)Double.valueOf(value.n.doubleValue());
        }
        if (value.b != null) {
            return (T)value.b;
        }
        if (value.s != null) {
            return (T)value.s;
        }
        if (value.u != null) {
            try {
                return (T)new URL(value.u);
            }
            catch (MalformedURLException e) {
                throw new PlaywrightException("Unexpected value: " + value.u, e);
            }
        }
        if (value.bi != null) {
            return (T)new BigInteger(value.bi);
        }
        if (value.d != null) {
            return (T)Date.from(Instant.parse(value.d));
        }
        if (value.r != null) {
            return (T)Pattern.compile(value.r.p, Utils.fromJsRegexFlags(value.r.f));
        }
        if (value.e != null) {
            return (T)new Exception(value.e.s);
        }
        if (value.v != null) {
            switch (value.v) {
                case "undefined": 
                case "null": {
                    return null;
                }
                case "Infinity": {
                    return (T)Double.valueOf(Double.POSITIVE_INFINITY);
                }
                case "-Infinity": {
                    return (T)Double.valueOf(Double.NEGATIVE_INFINITY);
                }
                case "-0": {
                    return (T)Double.valueOf(-0.0);
                }
                case "NaN": {
                    return (T)Double.valueOf(Double.NaN);
                }
            }
            throw new PlaywrightException("Unexpected value: " + value.v);
        }
        if (value.a != null) {
            ArrayList<T> list = new ArrayList<T>();
            idToValue.put(value.id, list);
            for (SerializedValue v : value.a) {
                list.add(Serialization.deserialize(v, idToValue));
            }
            return (T)list;
        }
        if (value.o != null) {
            LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
            idToValue.put(value.id, map);
            for (SerializedValue.O o : value.o) {
                map.put(o.k, Serialization.deserialize(o.v, idToValue));
            }
            return (T)map;
        }
        if (value.m != null) {
            LinkedHashMap map = new LinkedHashMap();
            idToValue.put(value.id, map);
            return (T)map;
        }
        if (value.se != null) {
            LinkedHashMap map = new LinkedHashMap();
            idToValue.put(value.id, map);
            return (T)map;
        }
        throw new PlaywrightException("Unexpected result: " + Serialization.gson().toJson((Object)value));
    }

    static JsonArray toJsonArray(Path[] files) {
        JsonArray jsonFiles = new JsonArray();
        for (Path p : files) {
            jsonFiles.add(p.toAbsolutePath().toString());
        }
        return jsonFiles;
    }

    static JsonArray toJsonArray(FilePayload[] files) {
        JsonArray jsonFiles = new JsonArray();
        for (FilePayload p : files) {
            jsonFiles.add((JsonElement)Serialization.toProtocol(p));
        }
        return jsonFiles;
    }

    static JsonObject toProtocol(FilePayload p) {
        JsonObject jsonFile = new JsonObject();
        jsonFile.addProperty("name", p.name);
        jsonFile.addProperty("mimeType", p.mimeType);
        jsonFile.addProperty("buffer", Base64.getEncoder().encodeToString(p.buffer));
        return jsonFile;
    }

    static JsonArray toProtocol(ElementHandle[] handles) {
        JsonArray jsonElements = new JsonArray();
        for (ElementHandle handle : handles) {
            jsonElements.add((JsonElement)((ElementHandleImpl)handle).toProtocolRef());
        }
        return jsonElements;
    }

    static JsonArray toProtocol(Map<String, String> map) {
        for (String value : map.values()) {
            if (value != null) continue;
            throw new PlaywrightException("Value cannot be null");
        }
        return Serialization.toNameValueArray(map.entrySet());
    }

    static void addHarUrlFilter(JsonObject options, Object urlFilter) {
        if (urlFilter instanceof String) {
            options.addProperty("urlGlob", (String)urlFilter);
        } else if (urlFilter instanceof Pattern) {
            Pattern pattern = (Pattern)urlFilter;
            options.addProperty("urlRegexSource", pattern.pattern());
            options.addProperty("urlRegexFlags", Utils.toJsRegexFlags(pattern));
        }
    }

    static JsonArray toNameValueArray(Iterable<? extends Map.Entry<String, ?>> collection) {
        JsonArray array = new JsonArray();
        for (Map.Entry<String, ?> e : collection) {
            JsonObject item = new JsonObject();
            item.addProperty("name", e.getKey());
            if (e.getValue() instanceof FilePayload) {
                item.add("value", Serialization.gson().toJsonTree(e.getValue()));
            } else {
                item.addProperty("value", "" + e.getValue());
            }
            array.add((JsonElement)item);
        }
        return array;
    }

    static JsonArray toSelectValueOrLabel(String[] values) {
        JsonArray jsonOptions = new JsonArray();
        for (String value : values) {
            JsonObject option = new JsonObject();
            option.addProperty("valueOrLabel", value);
            jsonOptions.add((JsonElement)option);
        }
        return jsonOptions;
    }

    static Map<String, String> fromNameValues(JsonArray array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (JsonElement element : array) {
            JsonObject pair = element.getAsJsonObject();
            map.put(pair.get("name").getAsString(), pair.get("value").getAsString());
        }
        return map;
    }

    static List<String> parseStringList(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonElement e : array) {
            result.add(e.getAsString());
        }
        return result;
    }

    private static DateFormat iso8601Format() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    private static class LocalDateTimeSerializer
    implements JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        public JsonElement serialize(LocalDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(src);
            Instant instant = src.toInstant(offset);
            return new JsonPrimitive(dateFormat.format(Date.from(instant)));
        }
    }

    private static class OffsetDateTimeSerializer
    implements JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
        }

        public JsonElement serialize(OffsetDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(dateFormat.format(Date.from(src.toInstant())));
        }
    }

    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(dateFormat.format(src));
        }
    }

    private static class SameSiteAdapter
    extends TypeAdapter<SameSiteAttribute> {
        private SameSiteAdapter() {
        }

        public void write(JsonWriter out, SameSiteAttribute value) throws IOException {
            String stringValue;
            switch (value) {
                case STRICT: {
                    stringValue = "Strict";
                    break;
                }
                case LAX: {
                    stringValue = "Lax";
                    break;
                }
                case NONE: {
                    stringValue = "None";
                    break;
                }
                default: {
                    throw new PlaywrightException("Unexpected value: " + (Object)((Object)value));
                }
            }
            out.value(stringValue);
        }

        public SameSiteAttribute read(JsonReader in) throws IOException {
            String value = in.nextString();
            return SameSiteAttribute.valueOf(value.toUpperCase());
        }
    }

    private static class ToLowerCaseSerializer<E extends Enum<E>>
    implements JsonSerializer<E> {
        private ToLowerCaseSerializer() {
        }

        public JsonElement serialize(E src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).toString().toLowerCase());
        }
    }

    private static class PathSerializer
    implements JsonSerializer<Path> {
        private PathSerializer() {
        }

        public JsonElement serialize(Path src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    private static class ToLowerCaseAndDashSerializer<E extends Enum<E>>
    implements JsonSerializer<E> {
        private ToLowerCaseAndDashSerializer() {
        }

        public JsonElement serialize(E src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).toString().toLowerCase().replace('_', '-'));
        }
    }

    private static class StringMapSerializer
    implements JsonSerializer<Map<String, String>> {
        private StringMapSerializer() {
        }

        public JsonElement serialize(Map<String, String> src, Type typeOfSrc, JsonSerializationContext context) {
            if (!"java.util.Map<java.lang.String, java.lang.String>".equals(typeOfSrc.getTypeName())) {
                throw new PlaywrightException("Unexpected map type: " + typeOfSrc);
            }
            return Serialization.toProtocol(src);
        }
    }

    private static class FirefoxUserPrefsSerializer
    implements JsonSerializer<Map<String, Object>> {
        private FirefoxUserPrefsSerializer() {
        }

        public JsonElement serialize(Map<String, Object> src, Type typeOfSrc, JsonSerializationContext context) {
            if (!"java.util.Map<java.lang.String, java.lang.Object>".equals(typeOfSrc.getTypeName())) {
                throw new PlaywrightException("Unexpected map type: " + typeOfSrc);
            }
            return context.serialize(src, Map.class);
        }
    }

    private static class HandleSerializer
    implements JsonSerializer<JSHandleImpl> {
        private HandleSerializer() {
        }

        public JsonElement serialize(JSHandleImpl src, Type typeOfSrc, JsonSerializationContext context) {
            return src.toProtocolRef();
        }
    }

    private static class OptionalSerializer
    implements JsonSerializer<Optional<?>> {
        private OptionalSerializer() {
        }

        private static boolean isSupported(Type type) {
            return new TypeToken<Optional<Media>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ColorScheme>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<Contrast>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ForcedColors>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ReducedMotion>>(){}.getType().getTypeName().equals(type.getTypeName()) || new TypeToken<Optional<ViewportSize>>(){}.getType().getTypeName().equals(type.getTypeName());
        }

        public JsonElement serialize(Optional<?> src, Type typeOfSrc, JsonSerializationContext context) {
            assert (OptionalSerializer.isSupported(typeOfSrc)) : "Unexpected optional type: " + typeOfSrc.getTypeName();
            if (!src.isPresent()) {
                return new JsonPrimitive("no-override");
            }
            return context.serialize(src.get());
        }
    }

    private static class KeyboardModifiersSerializer
    implements JsonSerializer<List<KeyboardModifier>> {
        private KeyboardModifiersSerializer() {
        }

        public JsonArray serialize(List<KeyboardModifier> modifiers, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            if (modifiers.contains((Object)KeyboardModifier.ALT)) {
                result.add("Alt");
            }
            if (modifiers.contains((Object)KeyboardModifier.CONTROL)) {
                result.add("Control");
            }
            if (modifiers.contains((Object)KeyboardModifier.CONTROLORMETA)) {
                result.add("ControlOrMeta");
            }
            if (modifiers.contains((Object)KeyboardModifier.META)) {
                result.add("Meta");
            }
            if (modifiers.contains((Object)KeyboardModifier.SHIFT)) {
                result.add("Shift");
            }
            return result;
        }
    }

    private static class ValueSerializer {
        private final Map<HashableValue, Integer> valueToId = new HashMap<HashableValue, Integer>();
        private int lastId = 0;
        private final List<JSHandleImpl> handles = new ArrayList<JSHandleImpl>();
        private final SerializedValue serializedValue;

        ValueSerializer(Object value) {
            this.serializedValue = this.serializeValue(value);
        }

        SerializedArgument toSerializedArgument() {
            SerializedArgument result = new SerializedArgument();
            result.value = this.serializedValue;
            result.handles = new Channel[this.handles.size()];
            int i = 0;
            for (JSHandleImpl handle : this.handles) {
                result.handles[i] = new Channel();
                result.handles[i].guid = handle.guid;
                ++i;
            }
            return result;
        }

        private SerializedValue serializeValue(Object value) {
            SerializedValue result = new SerializedValue();
            if (value instanceof JSHandleImpl) {
                result.h = this.handles.size();
                this.handles.add((JSHandleImpl)value);
                return result;
            }
            if (value == null) {
                result.v = "undefined";
            } else if (value instanceof Double) {
                double d = (Double)value;
                if (d == Double.POSITIVE_INFINITY) {
                    result.v = "Infinity";
                } else if (d == Double.NEGATIVE_INFINITY) {
                    result.v = "-Infinity";
                } else if (d == 0.0) {
                    result.v = "-0";
                } else if (Double.isNaN(d)) {
                    result.v = "NaN";
                } else {
                    result.n = d;
                }
            } else if (value instanceof Boolean) {
                result.b = (Boolean)value;
            } else if (value instanceof Integer) {
                result.n = (Integer)value;
            } else if (value instanceof String) {
                result.s = (String)value;
            } else if (value instanceof Date) {
                result.d = ((Date)value).toInstant().toString();
            } else if (value instanceof LocalDateTime) {
                result.d = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toString();
            } else if (value instanceof URL) {
                result.u = ((URL)value).toString();
            } else if (value instanceof BigInteger) {
                result.bi = ((BigInteger)value).toString();
            } else if (value instanceof Pattern) {
                result.r = new SerializedValue.R();
                result.r.p = ((Pattern)value).pattern();
                result.r.f = Utils.toJsRegexFlags((Pattern)value);
            } else if (value instanceof Exception) {
                Exception exception = (Exception)value;
                result.e = new SerializedValue.E();
                result.e.m = exception.getMessage();
                result.e.n = exception.getClass().getSimpleName();
                StringWriter sw = new StringWriter();
                exception.printStackTrace(new PrintWriter(sw));
                result.e.s = sw.toString();
            } else {
                HashableValue mapKey = new HashableValue(value);
                Integer id = this.valueToId.get(mapKey);
                if (id != null) {
                    result.ref = id;
                } else {
                    result.id = ++this.lastId;
                    this.valueToId.put(mapKey, this.lastId);
                    if (value instanceof List) {
                        ArrayList<SerializedValue> list = new ArrayList<SerializedValue>();
                        for (Object o : (List)value) {
                            list.add(this.serializeValue(o));
                        }
                        result.a = list.toArray(new SerializedValue[0]);
                    } else if (value instanceof Map) {
                        ArrayList<SerializedValue.O> list = new ArrayList<SerializedValue.O>();
                        Map map = (Map)value;
                        for (Map.Entry e : map.entrySet()) {
                            SerializedValue.O o = new SerializedValue.O();
                            o.k = (String)e.getKey();
                            o.v = this.serializeValue(e.getValue());
                            list.add(o);
                        }
                        result.o = list.toArray(new SerializedValue.O[0]);
                    } else if (value instanceof Object[]) {
                        ArrayList<SerializedValue> list = new ArrayList<SerializedValue>();
                        for (Object o : (Object[])value) {
                            list.add(this.serializeValue(o));
                        }
                        result.a = list.toArray(new SerializedValue[0]);
                    } else {
                        throw new PlaywrightException("Unsupported type of argument: " + value);
                    }
                }
            }
            return result;
        }

        private static class HashableValue {
            final Object value;

            HashableValue(Object value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                return this.value == ((HashableValue)o).value;
            }

            public int hashCode() {
                return System.identityHashCode(this.value);
            }
        }
    }
}

