/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.CDPSession;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class BrowserImpl
extends ChannelOwner
implements Browser {
    final Set<BrowserContextImpl> contexts = new HashSet<BrowserContextImpl>();
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    boolean isConnectedOverWebSocket;
    private boolean isConnected = true;
    BrowserTypeImpl browserType;
    BrowserType.LaunchOptions launchOptions;
    private Path tracePath;
    String closeReason;

    BrowserImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void onDisconnected(Consumer<Browser> handler) {
        this.listeners.add(EventType.DISCONNECTED, handler);
    }

    @Override
    public void offDisconnected(Consumer<Browser> handler) {
        this.listeners.remove(EventType.DISCONNECTED, handler);
    }

    @Override
    public BrowserType browserType() {
        return this.browserType;
    }

    @Override
    public void close(Browser.CloseOptions options) {
        block6: {
            if (options == null) {
                options = new Browser.CloseOptions();
            }
            this.closeReason = options.reason;
            if (this.isConnectedOverWebSocket) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    throw new PlaywrightException("Failed to close browser connection", e);
                }
                return;
            }
            try {
                this.sendMessage("close");
            }
            catch (PlaywrightException e) {
                if (Utils.isSafeCloseError(e)) break block6;
                throw e;
            }
        }
    }

    void notifyRemoteClosed() {
        for (BrowserContextImpl context : new ArrayList<BrowserContextImpl>(this.contexts)) {
            for (PageImpl page : new ArrayList<PageImpl>(context.pages)) {
                page.didClose();
            }
            context.didClose();
        }
        this.didClose();
    }

    @Override
    public List<BrowserContext> contexts() {
        return new ArrayList<BrowserContext>(this.contexts);
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public BrowserContextImpl newContext(Browser.NewContextOptions options) {
        options = options == null ? new Browser.NewContextOptions() : Utils.convertType(options, Browser.NewContextOptions.class);
        Browser.NewContextOptions harOptions = Utils.clone(options);
        options.recordHarContent = null;
        options.recordHarMode = null;
        options.recordHarPath = null;
        options.recordHarOmitContent = null;
        options.recordHarUrlFilter = null;
        if (options.storageStatePath != null) {
            try {
                byte[] bytes = Files.readAllBytes(options.storageStatePath);
                options.storageState = new String(bytes, StandardCharsets.UTF_8);
                options.storageStatePath = null;
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read storage state from file", e);
            }
        }
        JsonObject storageState = null;
        if (options.storageState != null) {
            storageState = (JsonObject)new Gson().fromJson(options.storageState, JsonObject.class);
            options.storageState = null;
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (storageState != null) {
            params.add("storageState", (JsonElement)storageState);
        }
        if (options.recordVideoDir != null) {
            JsonObject recordVideo = new JsonObject();
            recordVideo.addProperty("dir", options.recordVideoDir.toAbsolutePath().toString());
            if (options.recordVideoSize != null) {
                recordVideo.add("size", Serialization.gson().toJsonTree((Object)options.recordVideoSize));
            }
            params.remove("recordVideoDir");
            params.remove("recordVideoSize");
            params.add("recordVideo", (JsonElement)recordVideo);
        } else if (options.recordVideoSize != null) {
            throw new PlaywrightException("recordVideoSize is set but recordVideoDir is null");
        }
        if (options.viewportSize != null) {
            if (options.viewportSize.isPresent()) {
                JsonElement size = params.get("viewportSize");
                params.remove("viewportSize");
                params.add("viewport", size);
            } else {
                params.remove("viewportSize");
                params.addProperty("noDefaultViewport", Boolean.valueOf(true));
            }
        }
        Utils.addToProtocol(params, options.clientCertificates);
        params.remove("acceptDownloads");
        if (options.acceptDownloads != null) {
            params.addProperty("acceptDownloads", options.acceptDownloads != false ? "accept" : "deny");
        }
        params.add("selectorEngines", Serialization.gson().toJsonTree(this.browserType.playwright.selectors.selectorEngines));
        params.addProperty("testIdAttributeName", this.browserType.playwright.selectors.testIdAttributeName);
        JsonElement result = this.sendMessage("newContext", params, NO_TIMEOUT);
        BrowserContextImpl context = (BrowserContextImpl)this.connection.getExistingObject(result.getAsJsonObject().getAsJsonObject("context").get("guid").getAsString());
        context.initializeHarFromOptions(harOptions);
        return context;
    }

    @Override
    public Page newPage(Browser.NewPageOptions options) {
        return this.withTitle("Create Page", () -> this.newPageImpl(options));
    }

    @Override
    public void startTracing(Page page, Browser.StartTracingOptions options) {
        if (options == null) {
            options = new Browser.StartTracingOptions();
        }
        this.tracePath = options.path;
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (page != null) {
            params.add("page", (JsonElement)((PageImpl)page).toProtocolRef());
        }
        this.sendMessage("startTracing", params, NO_TIMEOUT);
    }

    @Override
    public byte[] stopTracing() {
        JsonObject json = this.sendMessage("stopTracing").getAsJsonObject();
        ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("artifact").get("guid").getAsString());
        byte[] data = artifact.readAllBytes();
        artifact.delete();
        if (this.tracePath != null) {
            try {
                Files.createDirectories(this.tracePath.getParent(), new FileAttribute[0]);
                Files.write(this.tracePath, data, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to write trace file", e);
            }
            finally {
                this.tracePath = null;
            }
        }
        return data;
    }

    private Page newPageImpl(Browser.NewPageOptions options) {
        BrowserContextImpl context = this.newContext(Utils.convertType(options, Browser.NewContextOptions.class));
        PageImpl page = context.newPage();
        page.ownedContext = context;
        context.ownerPage = page;
        return page;
    }

    private String name() {
        return this.initializer.get("name").getAsString();
    }

    boolean isChromium() {
        return "chromium".equals(this.name());
    }

    @Override
    public String version() {
        return this.initializer.get("version").getAsString();
    }

    @Override
    void handleEvent(String event, JsonObject parameters) {
        switch (event) {
            case "context": {
                this.didCreateContext((BrowserContextImpl)this.connection.getExistingObject(parameters.getAsJsonObject("context").get("guid").getAsString()));
                break;
            }
            case "close": {
                this.didClose();
            }
        }
    }

    @Override
    public CDPSession newBrowserCDPSession() {
        JsonObject params = new JsonObject();
        JsonObject result = this.sendMessage("newBrowserCDPSession", params, NO_TIMEOUT).getAsJsonObject();
        return (CDPSession)this.connection.getExistingObject(result.getAsJsonObject("session").get("guid").getAsString());
    }

    protected void connectToBrowserType(BrowserTypeImpl browserType, Path tracesDir) {
        this.browserType = browserType;
        this.tracePath = tracesDir;
        for (BrowserContextImpl context : this.contexts) {
            context.tracing().setTracesDir(tracesDir);
            browserType.playwright.selectors.contextsForSelectors.add(context);
        }
    }

    private void didCreateContext(BrowserContextImpl context) {
        context.browser = this;
        this.contexts.add(context);
        if (this.browserType != null) {
            context.tracing().setTracesDir(this.tracePath);
            this.browserType.playwright.selectors.contextsForSelectors.add(context);
        }
    }

    private void didClose() {
        this.isConnected = false;
        this.listeners.notify(EventType.DISCONNECTED, this);
    }

    static enum EventType {
        DISCONNECTED;

    }
}

