/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ConsoleMessage;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.PageImpl;
import java.util.ArrayList;
import java.util.List;

public class ConsoleMessageImpl
implements ConsoleMessage {
    private final Connection connection;
    private PageImpl page;
    private final JsonObject initializer;

    public ConsoleMessageImpl(Connection connection, JsonObject initializer) {
        this.connection = connection;
        if (initializer.has("page")) {
            this.page = (PageImpl)connection.getExistingObject(initializer.getAsJsonObject("page").get("guid").getAsString());
        }
        this.initializer = initializer;
    }

    @Override
    public String type() {
        return this.initializer.get("type").getAsString();
    }

    @Override
    public String text() {
        return this.initializer.get("text").getAsString();
    }

    @Override
    public List<JSHandle> args() {
        ArrayList<JSHandle> result = new ArrayList<JSHandle>();
        for (JsonElement item : this.initializer.getAsJsonArray("args")) {
            result.add((JSHandle)this.connection.getExistingObject(item.getAsJsonObject().get("guid").getAsString()));
        }
        return result;
    }

    @Override
    public String location() {
        JsonObject location = this.initializer.getAsJsonObject("location");
        return location.get("url").getAsString() + ":" + location.get("lineNumber").getAsNumber() + ":" + location.get("columnNumber").getAsNumber();
    }

    @Override
    public PageImpl page() {
        return this.page;
    }
}

