/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.Download;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.PageImpl;
import java.io.InputStream;
import java.nio.file.Path;

class DownloadImpl
implements Download {
    private final PageImpl page;
    private final ArtifactImpl artifact;
    private final JsonObject initializer;

    DownloadImpl(PageImpl page, ArtifactImpl artifact, JsonObject initializer) {
        this.page = page;
        this.artifact = artifact;
        this.initializer = initializer;
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    @Override
    public String suggestedFilename() {
        return this.initializer.get("suggestedFilename").getAsString();
    }

    @Override
    public void cancel() {
        this.artifact.cancel();
    }

    @Override
    public InputStream createReadStream() {
        return this.artifact.createReadStream();
    }

    @Override
    public void delete() {
        this.artifact.delete();
    }

    @Override
    public String failure() {
        return this.artifact.failure();
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public Path path() {
        return this.artifact.pathAfterFinished();
    }

    @Override
    public void saveAs(Path path) {
        this.artifact.saveAs(path);
    }
}

