/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ChannelOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class ListenerCollection<EventType> {
    private final HashMap<EventType, List<Consumer<?>>> listeners = new HashMap();
    private final Map<EventType, String> eventSubscriptions;
    private final ChannelOwner channelOwner;

    ListenerCollection() {
        this(null, null);
    }

    ListenerCollection(Map<EventType, String> eventSubscriptions, ChannelOwner channelOwner) {
        this.eventSubscriptions = eventSubscriptions;
        this.channelOwner = channelOwner;
    }

    <T> void notify(EventType eventType, T param) {
        List<Consumer<?>> list = this.listeners.get(eventType);
        if (list == null) {
            return;
        }
        for (Consumer<?> listener : new ArrayList(list)) {
            listener.accept(param);
        }
    }

    void add(EventType type, Consumer<?> listener) {
        if (listener == null) {
            throw new PlaywrightException("Can't add a null listener");
        }
        List<Consumer<?>> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList();
            this.listeners.put(type, list);
            this.updateSubscription(type, true);
        }
        list.add(listener);
    }

    void remove(EventType type, Consumer<?> listener) {
        List<Consumer<Consumer<?>>> list = this.listeners.get(type);
        if (list == null) {
            return;
        }
        list.removeAll(Collections.singleton(listener));
        if (list.isEmpty()) {
            this.updateSubscription(type, false);
            this.listeners.remove(type);
        }
    }

    boolean hasListeners(EventType type) {
        return this.listeners.containsKey(type);
    }

    private void updateSubscription(EventType eventType, boolean enabled) {
        if (this.eventSubscriptions == null) {
            return;
        }
        String protocolEvent = this.eventSubscriptions.get(eventType);
        if (protocolEvent == null) {
            return;
        }
        JsonObject params = new JsonObject();
        params.addProperty("event", protocolEvent);
        params.addProperty("enabled", Boolean.valueOf(enabled));
        this.channelOwner.sendMessageAsync("updateSubscription", params);
    }
}

