/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.Waitable;
import com.microsoft.playwright.impl.WaitableNever;
import com.microsoft.playwright.impl.WaitableTimeout;

class TimeoutSettings {
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private static final int DEFAULT_LAUNCH_TIMEOUT_MS = 180000;
    private final TimeoutSettings parent;
    private Double defaultTimeout;
    private Double defaultNavigationTimeout;

    TimeoutSettings() {
        this(null);
    }

    TimeoutSettings(TimeoutSettings parent) {
        this.parent = parent;
    }

    Double defaultTimeout() {
        return this.defaultTimeout;
    }

    Double defaultNavigationTimeout() {
        return this.defaultNavigationTimeout;
    }

    void setDefaultTimeout(Double timeout) {
        this.defaultTimeout = timeout;
    }

    void setDefaultNavigationTimeout(Double timeout) {
        this.defaultNavigationTimeout = timeout;
    }

    double timeout(Double timeout) {
        if (timeout != null) {
            return timeout;
        }
        if (this.defaultTimeout != null) {
            return this.defaultTimeout;
        }
        if (this.parent != null) {
            return this.parent.timeout(timeout);
        }
        return 30000.0;
    }

    double navigationTimeout(Double timeout) {
        if (timeout != null) {
            return timeout;
        }
        if (this.defaultNavigationTimeout != null) {
            return this.defaultNavigationTimeout;
        }
        if (this.defaultTimeout != null) {
            return this.defaultTimeout;
        }
        if (this.parent != null) {
            return this.parent.navigationTimeout(timeout);
        }
        return 30000.0;
    }

    <T> Waitable<T> createWaitable(Double timeout) {
        if (timeout != null && timeout == 0.0) {
            return new WaitableNever();
        }
        return new WaitableTimeout(this.timeout(timeout));
    }

    static double launchTimeout(Double timeout) {
        if (timeout != null) {
            return timeout;
        }
        return 180000.0;
    }
}

