/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.junit;

import com.microsoft.playwright.APIRequest;
import com.microsoft.playwright.APIRequestContext;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.junit.ExtensionUtils;
import com.microsoft.playwright.impl.junit.OptionsExtension;
import com.microsoft.playwright.impl.junit.PlaywrightExtension;
import com.microsoft.playwright.junit.Options;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class APIRequestContextExtension
implements ParameterResolver,
BeforeEachCallback,
AfterAllCallback {
    private static final ThreadLocal<APIRequestContext> threadLocalAPIRequestContext = new ThreadLocal();

    public void beforeEach(ExtensionContext extensionContext) {
        threadLocalAPIRequestContext.remove();
    }

    public void afterAll(ExtensionContext extensionContext) {
        threadLocalAPIRequestContext.remove();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return ExtensionUtils.isParameterSupported(parameterContext, extensionContext, APIRequestContext.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return APIRequestContextExtension.getOrCreateAPIRequestContext(extensionContext);
    }

    public static APIRequestContext getOrCreateAPIRequestContext(ExtensionContext extensionContext) {
        APIRequestContext apiRequestContext = threadLocalAPIRequestContext.get();
        if (apiRequestContext != null) {
            return apiRequestContext;
        }
        Options options = OptionsExtension.getOptions(extensionContext);
        Playwright playwright = PlaywrightExtension.getOrCreatePlaywright(extensionContext);
        apiRequestContext = playwright.request().newContext(APIRequestContextExtension.getContextOptions(options));
        threadLocalAPIRequestContext.set(apiRequestContext);
        return apiRequestContext;
    }

    private static APIRequest.NewContextOptions getContextOptions(Options options) {
        APIRequest.NewContextOptions contextOptions = Utils.clone(options.apiRequestOptions);
        if (contextOptions == null) {
            contextOptions = new APIRequest.NewContextOptions();
        }
        if (options.ignoreHTTPSErrors != null) {
            contextOptions.ignoreHTTPSErrors = options.ignoreHTTPSErrors;
        }
        return contextOptions;
    }
}

