/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.junit;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Tracing;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.junit.BrowserExtension;
import com.microsoft.playwright.impl.junit.DeviceDescriptor;
import com.microsoft.playwright.impl.junit.ExtensionUtils;
import com.microsoft.playwright.impl.junit.OptionsExtension;
import com.microsoft.playwright.impl.junit.PageExtension;
import com.microsoft.playwright.impl.junit.PlaywrightExtension;
import com.microsoft.playwright.junit.Options;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;

public class BrowserContextExtension
implements ParameterResolver,
TestWatcher {
    private static final ThreadLocal<BrowserContext> threadLocalBrowserContext = new ThreadLocal();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return !ExtensionUtils.isClassHook(extensionContext) && ExtensionUtils.isParameterSupported(parameterContext, extensionContext, BrowserContext.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return BrowserContextExtension.getOrCreateBrowserContext(extensionContext);
    }

    public static BrowserContext getOrCreateBrowserContext(ExtensionContext extensionContext) {
        BrowserContext browserContext = threadLocalBrowserContext.get();
        if (browserContext != null) {
            return browserContext;
        }
        Options options = OptionsExtension.getOptions(extensionContext);
        Playwright playwright = PlaywrightExtension.getOrCreatePlaywright(extensionContext);
        ExtensionUtils.setTestIdAttribute(playwright, options);
        Browser browser = BrowserExtension.getOrCreateBrowser(extensionContext);
        Browser.NewContextOptions contextOptions = BrowserContextExtension.getContextOptions(playwright, options);
        browserContext = browser.newContext(contextOptions);
        if (BrowserContextExtension.shouldRecordTrace(options)) {
            Tracing.StartOptions startOptions = new Tracing.StartOptions().setSnapshots(true).setScreenshots(true).setTitle(extensionContext.getDisplayName());
            if (System.getenv("PLAYWRIGHT_JAVA_SRC") != null) {
                startOptions.setSources(true);
            }
            browserContext.tracing().start(startOptions);
        }
        threadLocalBrowserContext.set(browserContext);
        return browserContext;
    }

    public void testSuccessful(ExtensionContext extensionContext) {
        BrowserContextExtension.saveTraceWhenOn(extensionContext);
        this.closeBrowserContext();
    }

    public void testAborted(ExtensionContext extensionContext, Throwable cause) {
        BrowserContextExtension.saveTraceWhenOn(extensionContext);
        this.closeBrowserContext();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        Options options = OptionsExtension.getOptions(extensionContext);
        if (BrowserContextExtension.shouldRecordTrace(options)) {
            BrowserContextExtension.saveTrace(extensionContext);
        }
        this.closeBrowserContext();
    }

    private static void saveTraceWhenOn(ExtensionContext extensionContext) {
        Options options = OptionsExtension.getOptions(extensionContext);
        if (options.trace.equals((Object)Options.Trace.ON)) {
            BrowserContextExtension.saveTrace(extensionContext);
        }
    }

    private static void saveTrace(ExtensionContext extensionContext) {
        BrowserContext browserContext = threadLocalBrowserContext.get();
        if (browserContext == null) {
            return;
        }
        Path outputPath = BrowserContextExtension.getOutputPath(extensionContext);
        BrowserContextExtension.createOutputPath(outputPath);
        Tracing.StopOptions stopOptions = new Tracing.StopOptions().setPath(outputPath.resolve("trace.zip"));
        browserContext.tracing().stop(stopOptions);
    }

    private static void createOutputPath(Path outputPath) {
        if (!Files.exists(outputPath, new LinkOption[0])) {
            try {
                Files.createDirectories(outputPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Path getOutputPath(ExtensionContext extensionContext) {
        BrowserType browserType = BrowserExtension.getBrowser().browserType();
        Path defaultOutputPath = BrowserContextExtension.getDefaultOutputPath(extensionContext);
        String outputDirName = extensionContext.getRequiredTestClass().getName() + "." + extensionContext.getRequiredTestMethod().getName() + "-" + browserType.name();
        return defaultOutputPath.resolve(outputDirName);
    }

    private static Path getDefaultOutputPath(ExtensionContext extensionContext) {
        Options options = OptionsExtension.getOptions(extensionContext);
        Path outputPath = options.outputDir;
        if (outputPath == null) {
            outputPath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("test-results");
        }
        return outputPath;
    }

    private void closeBrowserContext() {
        PageExtension.cleanUpPage();
        BrowserContext browserContext = threadLocalBrowserContext.get();
        threadLocalBrowserContext.remove();
        if (browserContext != null) {
            browserContext.close();
        }
    }

    private static boolean shouldRecordTrace(Options options) {
        return options.trace.equals((Object)Options.Trace.ON) || options.trace.equals((Object)Options.Trace.RETAIN_ON_FAILURE);
    }

    private static Browser.NewContextOptions getContextOptions(Playwright playwright, Options options) {
        Browser.NewContextOptions contextOptions = Utils.clone(options.contextOptions);
        if (contextOptions == null) {
            contextOptions = new Browser.NewContextOptions();
        }
        if (options.baseUrl != null) {
            contextOptions.setBaseURL(options.baseUrl);
        }
        if (options.deviceName != null) {
            DeviceDescriptor deviceDescriptor = DeviceDescriptor.findByName(playwright, options.deviceName);
            if (deviceDescriptor == null) {
                throw new PlaywrightException("Unknown device name: " + options.deviceName);
            }
            contextOptions.userAgent = deviceDescriptor.userAgent;
            if (deviceDescriptor.viewport != null) {
                contextOptions.setViewportSize(deviceDescriptor.viewport.width, deviceDescriptor.viewport.height);
            }
            contextOptions.deviceScaleFactor = deviceDescriptor.deviceScaleFactor;
            contextOptions.isMobile = deviceDescriptor.isMobile;
            contextOptions.hasTouch = deviceDescriptor.hasTouch;
        }
        if (options.ignoreHTTPSErrors != null) {
            contextOptions.setIgnoreHTTPSErrors(options.ignoreHTTPSErrors);
        }
        return contextOptions;
    }
}

