/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.junit;

import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.impl.junit.BrowserContextExtension;
import com.microsoft.playwright.impl.junit.ExtensionUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class PageExtension
implements ParameterResolver {
    private static final ThreadLocal<Page> threadLocalPage = new ThreadLocal();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return !ExtensionUtils.isClassHook(extensionContext) && ExtensionUtils.isParameterSupported(parameterContext, extensionContext, Page.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return PageExtension.getOrCreatePage(extensionContext);
    }

    public static Page getOrCreatePage(ExtensionContext extensionContext) {
        Page page = threadLocalPage.get();
        if (page != null) {
            return page;
        }
        BrowserContext browserContext = BrowserContextExtension.getOrCreateBrowserContext(extensionContext);
        page = browserContext.newPage();
        threadLocalPage.set(page);
        return page;
    }

    static void cleanUpPage() {
        threadLocalPage.remove();
    }
}

